unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.IO, System.Resources, System.Text,logFile;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    components: System.ComponentModel.IContainer;
    ComboBox1: System.Windows.Forms.ComboBox;
    ListView1: System.Windows.Forms.ListView;
    ImageList1: System.Windows.Forms.ImageList;
    Button1: System.Windows.Forms.Button;
    TextBox1: System.Windows.Forms.TextBox;
    Button2: System.Windows.Forms.Button;
    Button3: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TWinForm_Load(sender: System.Object; e: System.EventArgs);
    procedure ListView1_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
    procedure ComboBox1_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
    procedure ListView1_MouseDown(sender: System.Object; e: System.Windows.Forms.MouseEventArgs);
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure TextBox1_KeyPress(sender: System.Object; e: System.Windows.Forms.KeyPressEventArgs);
    procedure Button2_Click(sender: System.Object; e: System.EventArgs);
    procedure Button3_Click(sender: System.Object; e: System.EventArgs);
    procedure Button4_Click(sender: System.Object; e: System.EventArgs);
    procedure Button5_Click(sender: System.Object; e: System.EventArgs);
    procedure Button2_Click1(sender: System.Object; e: System.EventArgs);
    procedure Button3_Click1(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
    procedure ListujZawartoscKatalogu(Lista: ListView; image: ImageList; sciezka: String);
    function CzytajZPlikuTekstowego(nazwaPliku: String):String;
    procedure Kopiuj(co, gdzie: String);
  private
  path: String;
  log: PlikRejestrowania;
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]
 
implementation

{$AUTOBOX ON}
procedure TWinForm.Kopiuj(co: String; gdzie: String);
//var plik: FileInfo;
//var plik :System.IO.File;
begin
//plik:=System.IO.File.Create(co);
//if plik.Exists then
//plik.Copy(gdzie,false);
end;

function TWinForm.CzytajZPlikuTekstowego(nazwaPliku: String):String;
var sr: StreamReader;
begin
sr:=System.IO.StreamReader.Create(nazwaPliku);
Result:=sr.ReadToEnd;
end;
{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
var
  resources: System.Resources.ResourceManager;
begin
  Self.components := System.ComponentModel.Container.Create;
  resources := System.Resources.ResourceManager.Create(TypeOf(TWinForm));
  Self.ComboBox1 := System.Windows.Forms.ComboBox.Create;
  Self.ListView1 := System.Windows.Forms.ListView.Create;
  Self.ImageList1 := System.Windows.Forms.ImageList.Create(Self.components);
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.TextBox1 := System.Windows.Forms.TextBox.Create;
  Self.Button2 := System.Windows.Forms.Button.Create;
  Self.Button3 := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // ComboBox1
  // 
  Self.ComboBox1.Location := System.Drawing.Point.Create(10, 9);
  Self.ComboBox1.Name := 'ComboBox1';
  Self.ComboBox1.Size := System.Drawing.Size.Create(86, 24);
  Self.ComboBox1.TabIndex := 0;
  Include(Self.ComboBox1.SelectedIndexChanged, Self.ComboBox1_SelectedIndexChanged);
  // 
  // ListView1
  // 
  Self.ListView1.Location := System.Drawing.Point.Create(10, 83);
  Self.ListView1.Name := 'ListView1';
  Self.ListView1.Size := System.Drawing.Size.Create(393, 406);
  Self.ListView1.TabIndex := 1;
  Include(Self.ListView1.MouseDown, Self.ListView1_MouseDown);
  Include(Self.ListView1.SelectedIndexChanged, Self.ListView1_SelectedIndexChanged);
  // 
  // ImageList1
  // 
  Self.ImageList1.ImageSize := System.Drawing.Size.Create(16, 16);
  Self.ImageList1.ImageStream := (System.Windows.Forms.ImageListStreamer(resources.GetObject('I' +
    'mageList1.ImageStream')));
  Self.ImageList1.TransparentColor := System.Drawing.Color.Transparent;
  // 
  // Button1
  // 
  Self.Button1.Location := System.Drawing.Point.Create(346, 9);
  Self.Button1.Name := 'Button1';
  Self.Button1.Size := System.Drawing.Size.Create(57, 27);
  Self.Button1.TabIndex := 2;
  Self.Button1.Text := 'Up';
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // TextBox1
  // 
  Self.TextBox1.Location := System.Drawing.Point.Create(10, 46);
  Self.TextBox1.Name := 'TextBox1';
  Self.TextBox1.Size := System.Drawing.Size.Create(393, 22);
  Self.TextBox1.TabIndex := 3;
  Self.TextBox1.Text := '';
  Include(Self.TextBox1.KeyPress, Self.TextBox1_KeyPress);
  // 
  // Button2
  // 
  Self.Button2.Location := System.Drawing.Point.Create(10, 498);
  Self.Button2.Name := 'Button2';
  Self.Button2.Size := System.Drawing.Size.Create(90, 27);
  Self.Button2.TabIndex := 4;
  Self.Button2.Text := 'Plik .txt';
  Include(Self.Button2.Click, Self.Button2_Click1);
  // 
  // Button3
  // 
  Self.Button3.Location := System.Drawing.Point.Create(115, 498);
  Self.Button3.Name := 'Button3';
  Self.Button3.Size := System.Drawing.Size.Create(90, 27);
  Self.Button3.TabIndex := 5;
  Self.Button3.Text := 'Czytaj .txt';
  Include(Self.Button3.Click, Self.Button3_Click1);
  // 
  // TWinForm
  // 
  Self.AutoScale := False;
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(6, 15);
  Self.ClientSize := System.Drawing.Size.Create(412, 533);
  Self.Controls.Add(Self.Button3);
  Self.Controls.Add(Self.Button2);
  Self.Controls.Add(Self.TextBox1);
  Self.Controls.Add(Self.Button1);
  Self.Controls.Add(Self.ListView1);
  Self.Controls.Add(Self.ComboBox1);
  Self.Name := 'TWinForm';
  Self.Text := 'FileListView (Windows Forms)';
  Include(Self.Load, Self.TWinForm_Load);
  Self.ResumeLayout(False);
end;
{$ENDREGION}
procedure TWinForm.ListujZawartoscKatalogu(lista: ListView; image: ImageList; sciezka: String);
var katalog,plik: array of String;
    item: String;
    i: integer;
begin
lista.Clear;
lista.largeImageList:=image;
try
  katalog:= System.IO.Directory.GetDirectories(sciezka);
for i:=0 to length(katalog)-1 do
begin
  item:=katalog[i].Remove(0,katalog[i].LastIndexOf('\')+1);
  Lista.Items.Add(item,0);
end;
  plik:=System.IO.Directory.GetFiles(sciezka);
for  i:=0 to length(plik)-1 do
begin
  item:=plik[i].Remove(0,plik[i].LastIndexOf('\')+1);
  lista.Items.Add(item,1) ;
end;
except
 MessageBox.Show('Urzdzenie lub katalog '+sciezka+' nie jest dostpne');
end;
end;

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm.Button3_Click1(sender: System.Object; e: System.EventArgs);
begin
MessageBox.Show(Self.CzytajZPlikuTekstowego('c:\plik.txt'));
end;

procedure TWinForm.Button2_Click1(sender: System.Object; e: System.EventArgs);
var sw: StreamWriter;
    i: Integer;
begin
if not System.IO.File.Exists('c:\plik.txt') then
begin
  sw:= System.IO.File.CreateText('c:\plik.txt');
  try
    sw.WriteLine('Zawarto katalogu '+path);
    for i:=0 to ListView1.Items.Count-1 do
      sw.WriteLine(ListView1.Items.Item[i].Text);
  finally
  sw.Close;
  end;
end;
end;

procedure TWinForm.Button5_Click(sender: System.Object; e: System.EventArgs);
var plik: FileInfo;
    w: String;
begin
plik:=FileInfo.Create('c:\bigman\plik.txt');
w:='Pena nazwa pliku:  '+plik.FullName+#13;
w:=w+'Nazwa katalogu:  '+plik.DirectoryName+#13;
w:=w+'Nazwa pliku:  '+plik.Name+#13;
w:=w+'Rozszerzenie pliku:  '+plik.Extension+#13;
w:=w+'Symbol dysku:  '+plik.ToString.Remove(plik.ToString.IndexOf('\'),plik.ToString.Length-plik.ToString.IndexOf('\'))+#13;
MessageBox.Show(w);
end;

procedure TWinForm.Button4_Click(sender: System.Object; e: System.EventArgs);
begin
Kopiuj('c:\plik.txt','t:\plik.txt');
end;

procedure TWinForm.Button3_Click(sender: System.Object; e: System.EventArgs);
begin
MessageBox.Show(Self.CzytajZPlikuTekstowego('c:\plik.txt'));
end;

procedure TWinForm.Button2_Click(sender: System.Object; e: System.EventArgs);
var plik: FileInfo;
    zapis: StreamWriter;
    i: integer;
begin
plik:=FileInfo.Create(path+'plik.txt');
zapis:=plik.CreateText;
zapis.WriteLine('Zawarto katalogu '+path);
for i:=0 to ListView1.Items.Count-1 do
zapis.WriteLine(ListView1.Items.Item[i].Text);
zapis.Close;
end;

procedure TWinForm.TextBox1_KeyPress(sender: System.Object; e: System.Windows.Forms.KeyPressEventArgs);
begin
    if e.KeyChar=Char(13) then
    begin
      if textbox1.Text.EndsWith('\')=false then
        textbox1.Text:=textbox1.Text+'\';
      path:=TextBox1.Text;
      ListujZawartoscKatalogu(Listview1,ImageList1,path);
    end;
end;

procedure TWinForm.Button1_Click(sender: System.Object; e: System.EventArgs);
var dir: DirectoryInfo;
begin
dir:=DirectoryInfo.Create(TextBox1.Text);
if textbox1.TextLength>3 then
begin
textbox1.Text:=textbox1.Text.Remove(TextBox1.TextLength-(dir.Name.Length+1),dir.Name.Length+1);
path:=textbox1.Text;
ListujZawartoscKatalogu(Listview1,ImageList1,path);
end;
dir.Free;
end;

procedure TWinForm.ListView1_MouseDown(sender: System.Object; e: System.Windows.Forms.MouseEventArgs);
var wybor: ListViewItem;
begin
wybor:=ListViewItem.Create();
wybor:=ListView1.GetItemAt(e.X,e.Y);
if wybor=nil then exit;
if (wybor.ImageIndex=0) then
begin
  path:=path+wybor.Text+'\';
  ListujZawartoscKatalogu(Listview1,ImageList1,path);
  TextBox1.Text:=path;
end;
end;

procedure TWinForm.ComboBox1_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
begin
 path:=ComboBox1.Text;
 ListujZawartoscKatalogu(Listview1,ImageList1,path);
 TextBox1.Text:=path;
end;

procedure TWinForm.ListView1_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
begin

end;

procedure TWinForm.TWinForm_Load(sender: System.Object; e: System.EventArgs);
begin
ComboBox1.DataSource:=Environment.GetLogicalDrives;
TextBox1.Text:=path;
log:=PlikRejestrowania.Create('c:\log.txt');
  log.Dopisz('Uruchomienie aplikacji');
end;

end.
